{ listens = [ { address = "::", port = 59661 } ]
, certfile = "/etc/letsencrypt/cert.pem"
, keyfile = "/etc/letsencrypt/key.pem"
, mqtt_url = "tcp://mqtt:1883"
, db_path = "/var/lib/bffh/db"
, auditlog_path = "/tmp/bffh.audit"
, spacename = "FabAccess Local Test"
, instanceurl = "localtest.fab-access.org"
, roles =
  { Admin.permissions =
    [ "TestEnv.Admin"
    , "TestEnv.Manage.A"
    , "TestEnv.Manage.B"
    , "TestEnv.Manage.C"
    , "TestEnv.Write.A"
    , "TestEnv.Write.B"
    , "TestEnv.Write.C"
    , "TestEnv.Read.A"
    , "TestEnv.Read.B"
    , "TestEnv.Read.C"
    , "TestEnv.Disclose.A"
    , "TestEnv.Disclose.B"
    , "TestEnv.Disclose.C"
    ]
  , ManageUsers.permissions =
    [ "bffh.users.info", "bffh.users.manage", "bffh.users.admin" ]
  , ManageA.permissions = [ "TestEnv.Manage.A" ]
  , ManageB.permissions = [ "TestEnv.Manage.B" ]
  , ManageC.permissions = [ "TestEnv.Manage.C" ]
  , UseA.permissions = [ "TestEnv.Write.A" ]
  , UseB.permissions = [ "TestEnv.Write.B" ]
  , UseC.permissions = [ "TestEnv.Write.C" ]
  , ReadA.permissions = [ "TestEnv.Read.A" ]
  , ReadB.permissions = [ "TestEnv.Read.B" ]
  , ReadC.permissions = [ "TestEnv.Read.C" ]
  , DiscloseA.permissions = [ "TestEnv.Disclose.A" ]
  , DiscloseB.permissions = [ "TestEnv.Disclose.B" ]
  , DiscloseC.permissions = [ "TestEnv.Disclose.C" ]
  }
, machines =
  { MachineA1 =
    { name = "MachineA1"
    , description = "Description of MachineA1"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose.A"
    , read = "TestEnv.Read.A"
    , write = "TestEnv.Write.A"
    , manage = "TestEnv.Manage.A"
    }
  , MachineA2 =
    { name = "MachineA2"
    , description = "Description of MachineA2"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose.A"
    , read = "TestEnv.Read.A"
    , write = "TestEnv.Write.A"
    , manage = "TestEnv.Manage.A"
    }
  , MachineA3 =
    { name = "MachineA3"
    , description = "Description of MachineA3"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose.A"
    , read = "TestEnv.Read.A"
    , write = "TestEnv.Write.A"
    , manage = "TestEnv.Manage.A"
    }
  , MachineA4 =
    { name = "MachineA4"
    , description = "Description of MachineA4"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose.A"
    , read = "TestEnv.Read.A"
    , write = "TestEnv.Write.A"
    , manage = "TestEnv.Manage.A"
    }
  , MachineA5 =
    { name = "MachineA5"
    , description = "Description of MachineA5"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose.A"
    , read = "TestEnv.Read.A"
    , write = "TestEnv.Write.A"
    , manage = "TestEnv.Manage.A"
    }
  , MachineB1 =
    { name = "MachineB1"
    , description = "Description of MachineB1"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose.B"
    , read = "TestEnv.Read.B"
    , write = "TestEnv.Write.B"
    , manage = "TestEnv.Manage.B"
    }
  , MachineB2 =
    { name = "MachineB2"
    , description = "Description of MachineB2"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose.B"
    , read = "TestEnv.Read.B"
    , write = "TestEnv.Write.B"
    , manage = "TestEnv.Manage.B"
    }
  , MachineB3 =
    { name = "MachineB3"
    , description = "Description of MachineB3"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose.B"
    , read = "TestEnv.Read.B"
    , write = "TestEnv.Write.B"
    , manage = "TestEnv.Manage.B"
    }
  , MachineB4 =
    { name = "MachineB4"
    , description = "Description of MachineB4"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose.B"
    , read = "TestEnv.Read.B"
    , write = "TestEnv.Write.B"
    , manage = "TestEnv.Manage.B"
    }
  , MachineB5 =
    { name = "MachineB5"
    , description = "Description of MachineB5"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose.B"
    , read = "TestEnv.Read.B"
    , write = "TestEnv.Write.B"
    , manage = "TestEnv.Manage.B"
    }
  , MachineC1 =
    { name = "MachineC1"
    , description = "Description of MachineC1"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryC"
    , disclose = "TestEnv.Disclose.C"
    , read = "TestEnv.Read.C"
    , write = "TestEnv.Write.C"
    , manage = "TestEnv.Manage.C"
    }
  , MachineC2 =
    { name = "MachineC2"
    , description = "Description of MachineC2"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryC"
    , disclose = "TestEnv.Disclose.C"
    , read = "TestEnv.Read.C"
    , write = "TestEnv.Write.C"
    , manage = "TestEnv.Manage.C"
    }
  , MachineC3 =
    { name = "MachineC3"
    , description = "Description of MachineC3"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryC"
    , disclose = "TestEnv.Disclose.C"
    , read = "TestEnv.Read.C"
    , write = "TestEnv.Write.C"
    , manage = "TestEnv.Manage.C"
    }
  , MachineC4 =
    { name = "MachineC4"
    , description = "Description of MachineC4"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryC"
    , disclose = "TestEnv.Disclose.C"
    , read = "TestEnv.Read.C"
    , write = "TestEnv.Write.C"
    , manage = "TestEnv.Manage.C"
    }
  , MachineC5 =
    { name = "MachineC5"
    , description = "Description of MachineC5"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryC"
    , disclose = "TestEnv.Disclose.C"
    , read = "TestEnv.Read.C"
    , write = "TestEnv.Write.C"
    , manage = "TestEnv.Manage.C"
    }
  }
, actors = {=}
, actor_connections = [] : List { machine : Text, actor : Text }
, initiators = {=}
, init_connections = [] : List { machine : Text, initiator : Text }
}
