let VARS = {
	BFFH_CFG_PATH = "/etc/bffh/",
	BFFH_DB_PATH = "/var/lib/bffh/",
	MQTT_USER = "fabinfra101",
	MQTT_PASSWD = "fablocal"
	}
in 
{
    listens = [
        { address = "0.0.0.0", port = 59661 }
    ],
    certfile = VARS.BFFH_CFG_PATH ++ "certs/bffh.crt",
    keyfile = VARS.BFFH_CFG_PATH ++ "certs/bffh.key",
    mqtt_url = "mqtt://" ++ VARS.MQTT_USER ++ ":" ++ VARS.MQTT_PASSWD ++ "@0.0.0.0:1883",
	--ciphers = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
	--tls_min_version = "tls13",
    db_path = VARS.BFFH_DB_PATH ++ "bffh.db",
    auditlog_path = "/var/log/bffh/audit.json",

	--- ||| GENERATOR START
	--- ||| GENERATOR END

	roles = ./roles.dhall,
	machines = ./machines.dhall,
	actors = ./actors.dhall,
	actor_connections = ./actorconnections.dhall,

    initiators = {=},
    init_connections = [] : List { machine : Text, initiator : Text },
    
	instanceurl = "https://docs.fab-access.org",
    spacename = "FabAccess Demo Setup"
}
