{ listens = [ { address = "::", port = 59661 } ]
, certfile = "tfom23-demo/certs/self-signed-cert.pem"
, keyfile = "tfom23-demo/certs/self-signed-key.pem"
, mqtt_url = "mqtt://localhost:1883"
, db_path = "/var/lib/bffh/db"
, auditlog_path = "/tmp/bffh.audit"
, verbosity = 3
, spacename = "TFOM23-Demo"
, instanceurl = "tfom23-demo.fab-access.org"
, roles =
  { Default.permissions = [ "tfom23.disclose", "tfom23.read" ]
  , Admin.permissions =
    [ "tfom23.*", "bffh.users.info", "bffh.users.manage", "bffh.users.admin" ]
  , Manage.permissions = [ "tfom23.manage" ]
  , EuroBox.permissions = [ "tfom23.eurobox.write" ]
  , LBoxx.permissions = [ "tfom23.lboxx.write" ]
  , Locker.permissions = [ "tfom23.locker.write" ]
  , Lasercutter.permissions = [ "tfom23.lasercutter.write" ]
  , Printer.permissions = [ "tfom23.printer.write" ]
  , Prusa.permissions = [ "tfom23.prusa.write" ]
  , CNC.permissions = [ "tfom23.cnc.write" ]
  }
, machines =
  { LBoxx_0 =
    { name = "Filament"
    , description = "LBoxx with 1,75mm PLA"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lboxx.write"
    , manage = "tfom23.manage"
    , category = "LBoxx"
    , prodable = True
    }
  , LBoxx_1 =
    { name = "FabLock Tools"
    , description = "LBoxx with Tools of the FabLock Project"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lboxx.write"
    , manage = "tfom23.manage"
    , category = "LBoxx"
    , prodable = True
    }
  , LBoxx_2 =
    { name = "FabReader Tools"
    , description = "LBoxx with Tools of the FabReader Project"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lboxx.write"
    , manage = "tfom23.manage"
    , category = "LBoxx"
    , prodable = True
    }
  , LBoxx_3 =
    { name = "Sticker"
    , description = "LBoxx with FabAccess Sticker and NTAGs"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lboxx.write"
    , manage = "tfom23.manage"
    , category = "LBoxx"
    , prodable = True
    }
  , LBoxx_4 =
    { name = "Demo Parts"
    , description = "LBoxx with Parts for the TFOM23 Demo"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lboxx.write"
    , manage = "tfom23.manage"
    , category = "LBoxx"
    , prodable = True
    }
  , EuroBox_0 =
    { name = "Haribo"
    , description = "EuroBox with Haribo"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.eurobox.write"
    , manage = "tfom23.manage"
    , category = "EuroBox"
    , prodable = True
    }
  , EuroBox_1 =
    { name = "Goldschatz"
    , description = "EuroBox with Rittersport Goldschatz"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.eurobox.write"
    , manage = "tfom23.manage"
    , category = "EuroBox"
    , prodable = True
    }
  , Drawer_0 =
    { name = "Drawer 0 ???"
    , description = "Kallax Drawer"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.locker.write"
    , manage = "tfom23.manage"
    , category = "Locker"
    , prodable = True
    }
  , Drawer_1 =
    { name = "Drawer 1 ???"
    , description = "Kallax Drawer"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.locker.write"
    , manage = "tfom23.manage"
    , category = "Locker"
    , prodable = True
    }
  , Drawer_2 =
    { name = "Drawer 2 ???"
    , description = "Kallax Drawer"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.locker.write"
    , manage = "tfom23.manage"
    , category = "Locker"
    , prodable = True
    }
  , Drawer_3 =
    { name = "Drawer 3 ???"
    , description = "Kallax Drawer"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.locker.write"
    , manage = "tfom23.manage"
    , category = "Locker"
    , prodable = True
    }
  , Door_0 =
    { name = "3D-Printer Accesories"
    , description = "Kallax Door"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.locker.write"
    , manage = "tfom23.manage"
    , category = "Locker"
    , prodable = True
    }
  , Printer_0 =
    { name = "Prusa MK3"
    , description = "FabAccess Prusa MK3"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.prusa.write"
    , manage = "tfom23.manage"
    , category = "Printers"
    }
  , Printer_1 =
    { name = "Other Printer ???"
    , description = "TFOM23 Printer"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.printer.write"
    , manage = "tfom23.manage"
    , category = "Printers"
    }
  , Lasercutter_0 =
    { name = "Other Lasercutter ???"
    , description = "TFOM23 Lasercutter"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.lasercutter.write"
    , manage = "tfom23.manage"
    , category = "Lasercutter"
    }
  , CNC_0 =
    { name = "Some Open Hardware CNC Router"
    , description = "TFOM23 CNC"
    , disclose = "tfom23.disclose"
    , read = "tfom23.read"
    , write = "tfom23.cnc.write"
    , manage = "tfom23.manage"
    , category = "CNC"
    }
  }
, actors =
  { shellyplug-s-C8C9A3B942DB = { module = "Shelly", params = {=} }
  , shellyplug-s-C8C9A3B943D7 = { module = "Shelly", params = {=} }
  , shellyplug-s-C8C9A3B8DB67 = { module = "Shelly", params = {=} }
  , shellyplug-s-3CE90ED72CEF = { module = "Shelly", params = {=} }
  , shellyplug-s-3CE90ED72481 = { module = "Shelly", params = {=} }
  , shellyplug-s-C8C9A3B8E88A = { module = "Shelly", params = {=} }
  , shellyplug-2C94AA = { module = "Shelly", params = {=} }
  , shellyplug-C198E8 = { module = "Shelly", params = {=} }
  , fablock_locker_0 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00000"
      }
    }
  , fablock_locker_1 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00001"
      }
    }
  , fablock_locker_2 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00002"
      }
    }
  , fablock_locker_3 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00003"
      }
    }
  , fablock_locker_4 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00004"
      }
    }
  , fablock_locker_5 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00005"
      }
    }
  , fablock_locker_6 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00000 --lock 00006"
      }
    }
  , fablock_lboxx_0 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00001 --lock 00000"
      }
    }
  , fablock_lboxx_1 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00001 --lock 00001"
      }
    }
  , fablock_lboxx_2 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00001 --lock 00002"
      }
    }
  , fablock_lboxx_3 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00001 --lock 00003"
      }
    }
  , fablock_lboxx_4 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fablock/main.py --host localhost --fablock 00001 --lock 00004"
      }
    }
  , fabreader_0 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabreader/main.py --host localhost --fabreader 00000"
      }
    }
  , fabreader_1 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabreader/main.py --host localhost --fabreader 00001"
      }
    }
  , fabreader_2 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabreader/main.py --host localhost --fabreader 00002"
      }
    }
  , fabreader_3 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabreader/main.py --host localhost --fabreader 00003"
      }
    }
  , fabreader_4 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabreader/main.py --host localhost --fabreader 00004"
      }
    }
  , fabpel_0 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabpel/main.py --host localhost --fabpel 00000"
      }
    }
  , fabpel_1 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabpel/main.py --host localhost --fabpel 00001"
      }
    }
  , fabpel_2 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabpel/main.py --host localhost --fabpel 00002"
      }
    }
  , fabpel_3 =
    { module = "Process"
    , params =
      { cmd = "python"
      , args =
          "tfom23-demo/actors/fabpel/main.py --host localhost --fabpel 00003"
      }
    }
  }
, actor_connections =
  [ { machine = "LBoxx_0", actor = "fablock_lboxx_0" }
  , { machine = "LBoxx_1", actor = "fablock_lboxx_1" }
  , { machine = "LBoxx_2", actor = "fablock_lboxx_2" }
  , { machine = "LBoxx_3", actor = "fablock_lboxx_3" }
  , { machine = "LBoxx_4", actor = "fablock_lboxx_4" }
  , { machine = "EuroBox_0", actor = "fablock_locker_0" }
  , { machine = "EuroBox_1", actor = "fablock_locker_1" }
  , { machine = "Drawer_0", actor = "fablock_locker_2" }
  , { machine = "Drawer_1", actor = "fablock_locker_3" }
  , { machine = "Drawer_2", actor = "fablock_locker_4" }
  , { machine = "Drawer_3", actor = "fablock_locker_5" }
  , { machine = "Door_0", actor = "fablock_locker_6" }
  , { machine = "Printer_0", actor = "shellyplug-s-C8C9A3B942DB" }
  , { machine = "Printer_1", actor = "shellyplug-s-3CE90ED72481" }
  , { machine = "Lasercutter_0", actor = "shellyplug-s-C8C9A3B943D7" }
  , { machine = "CNC_0", actor = "shellyplug-s-C8C9A3B8E88A" }
  , { machine = "Printer_0", actor = "fabreader_1" }
  , { machine = "Printer_1", actor = "fabreader_2" }
  , { machine = "Lasercutter_0", actor = "fabreader_3" }
  , { machine = "CNC_0", actor = "fabreader_4" }
  , { machine = "Printer_0", actor = "fabpel_0" }
  , { machine = "Printer_1", actor = "fabpel_1" }
  , { machine = "Lasercutter_0", actor = "fabpel_2" }
  , { machine = "CNC_0", actor = "fabpel_3" }
  ]
, initiators = {=}
, init_connections = [] : List { machine : Text, initiator : Text }
}
