# BFFH Pakete für Linux Distributionen
Dieses Verzeichnis enthält Pakete für [Difluorobane (BFFH) Server](https://docs.fab-access.org/books/fabaccess-installation/page/downloads-demo#bkmrk-server-anwendung-dif) - inklusive optionaler Debug Symbols (dbgsym). 

Aktuell gibt es noch keine offiziellen Paket-Releases, jedoch finden sich ausgereiftere Testpakete im Unterodner [**development/**](https://downloads.fab-access.org/?dir=bffh-packages/development).

Die **Installationsanleitung** dafür liegt in [docs.fab-access.org](https://docs.fab-access.org/books/fabaccess-installation/page/server-installation-mit-distributionspaketen-deb-rpm).

Weitere Details finden sich auch in den [GitLab releases](https://gitlab.com/fabinfra/fabaccess/bffh/-/releases).

## Hinweise zu den Architekturen

Es gibt mehrere Synonyme bzw. Namensvarianten für gleiche Architekturen, was häufig verwirrt:

- armhf = arvm7 = armv7-unknown-linux-gnueabihf
- arm64 = aarch64 = aarch64-unknown-linux-gnu
- amd64 = x86_64-unknown-linux-gnu

## Debian / Ubuntu / Kubuntu (*.deb)

Die *.deb Dateien sind zum Installieren. Die *.sig bzw. *.sig.asc sind Dateien für die GnuPG Verifikation.

**armhf**
- fabaccess-bffh_VERSION_armhf.deb
- fabaccess-bffh_VERSION_armhf.sig
- fabaccess-bffh_VERSION_armhf.sig.asc
- fabaccess-bffh-dbgsym_VERSION_armhf.deb
- fabaccess-bffh-dbgsym_VERSION_armhf.sig
- fabaccess-bffh-dbgsym_VERSION_armhf.sig.asc

**arm64**
- fabaccess-bffh_VERSION_arm64.deb
- fabaccess-bffh_VERSION_arm64.sig
- fabaccess-bffh_VERSION_arm64.sig.asc
- fabaccess-bffh-dbgsym_VERSION_arm64.deb
- fabaccess-bffh-dbgsym_VERSION_arm64.sig
- fabaccess-bffh-dbgsym_VERSION_arm64.sig.asc

**x64_64**
- fabaccess-bffh_VERSION_amd64.deb
- fabaccess-bffh_VERSION_amd64.sig
- fabaccess-bffh_VERSION_amd64.sig.asc
- fabaccess-bffh-dbgsym_VERSION_amd64.deb
- fabaccess-bffh-dbgsym_VERSION_amd64.sig
- fabaccess-bffh-dbgsym_VERSION_amd64.sig.asc

## Fedora / CentOS / RHEL / Rocky Linux (*.rpm)

Diese Dateien werden aus *.deb durch [alien](https://wiki.ubuntuusers.de/Alien/) erzeugt.

**x64_64**
- fabaccess-bffh-VERSION-1.x86_64.rpm
- fabaccess-bffh-dbgsym-VERSION-1.x86_64.rpm

**armhf**
- fabaccess-bffh-VERSION-1.armhf.rpm
- fabaccess-bffh-dbgsym-VERSION-1.armhf.rpm

**arm64**
- fabaccess-bffh-VERSION-1.arm64.rpm
- fabaccess-bffh-dbgsym-VERSION-1.arm64.rpm

## Buildinfo
Diese Dateien werden beim Erzeugen der Debian Pakete mitgeliefert und geben Aufschluss darüber, mit welchen genauen Bibliotheksversionen die Binaries eingebunden wurden.

- fabaccess-bffh_VERSION_armhf.buildinfo
- fabaccess-bffh_VERSION_arm64.buildinfo
- fabaccess-bffh_VERSION_amd64.buildinfo
