{ listens = [ { address = "::", port = 59661 } ]
, certfile = "/etc/letsencrypt/cert.pem"
, keyfile = "/etc/letsencrypt/key.pem"
, mqtt_url = "tcp://mqtt:1883"
, db_path = "/var/lib/bffh/db"
, auditlog_path = "/tmp/bffh.audit"
, roles =
  { Admin.permissions =
    [ "TestEnv.Admin"
    , "TestEnv.Manage"
    , "TestEnv.Write"
    , "TestEnv.Read"
    , "TestEnv.Disclose"
    ]
  , ManageUsers.permissions =
    [ "bffh.users.info", "bffh.users.manage", "bffh.users.admin" ]
  , Manage.permissions = [ "TestEnv.Manage" ]
  , Use.permissions = [ "TestEnv.Write" ]
  , Read.permissions = [ "TestEnv.Read" ]
  , Disclose.permissions = [ "TestEnv.Disclose" ]
  }
, machines =
  { MachineB1 =
    { name = "Schließfach"
    , description = "Schließfach ohne elektrische Steuerung"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineB2 =
    { name = "Fabulaser"
    , description = "Fabulaser - compact, yet powerful"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryB"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineA1 =
    { name = "Machine Oben"
    , description = "Maschine mit QR-Code zum scannen"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineA2 =
    { name = "Machine Mitte"
    , description = "Maschine mit NFC Reader für DESFire Karten"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineA3 =
    { name = "Machine Unten"
    , description = "Maschine für weitere Dinge"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineA4 =
    { name = "Machine Drehstrom"
    , description = "Maschine mit Drehstromanschluss"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  , MachineA5 =
    { name = "Machine Drehstrom Anlaufschutz"
    , description = "Maschine mit Drehstromanschluss und Wiederanlaufschutz"
    , wiki = "https://fab-access.readthedocs.io"
    , category = "CategoryA"
    , disclose = "TestEnv.Disclose"
    , read = "TestEnv.Read"
    , write = "TestEnv.Write"
    , manage = "TestEnv.Manage"
    }
  }
, actors =
  { shellyplug-s-6E6ED9 = { module = "Shelly", params = {=} }
  , shellyplug-s-C18903 = { module = "Shelly", params = {=} }
  , shellyplug-s-B4C8B9 = { module = "Shelly", params = {=} }
  , shelly1-DDDDDDDDDDDD = { module = "Shelly", params = {=} }
  , shelly1-EEEEEEEEEEEE = { module = "Shelly", params = {=} }
  }
, actor_connections =
  [ { machine = "MachineA1", actor = "shellyplug-s-6E6ED9" }
  , { machine = "MachineA2", actor = "shellyplug-s-C18903" }
  , { machine = "MachineA3", actor = "shellyplug-s-B4C8B9" }
  , { machine = "MachineA4", actor = "shelly1-DDDDDDDDDDDD" }
  , { machine = "MachineA5", actor = "shelly1-DDDDDDDDDDDD" }
  ]
, initiators = {=}
, init_connections = [] : List { machine : Text, initiator : Text }
}
