  { listens =
    [ { address = "127.0.0.1", port = 59661 }
    , { address = "::1", port = 59661 }
    ]
  , certfile = "examples/cert.pem"
  , keyfile = "examples/key.pem"
  , mqtt_url = "tcp://makerspace-bocholt.redacted:1883"
  , db_path = "/root/BFFH/bffh/target/release/bffh"
  , auditlog_path = "/root/BFFH/bffh/target/release/bffh.audit"
  , roles =
    { doorrole.permissions =
      [ "doorrole.read"
      , "doorrole.write"
      , "doorrole.disclose"
      , "doorrole.manage"
      ]
    , basis.permissions = [ "basis.read", "basis.write", "basis.disclose" ]
    , hobby =
      { parents = [ "basis" ]
      , permissions = [ "hobby.read", "hobby.write", "hobby.disclose" ]
      }
    , profi =
      { parents = [ "hobby" ]
      , permissions = [ "profi.read", "profi.write", "profi.disclose" ]
      }
    , laser.permissions =
      [ "lab.laser.read"
      , "lab.laser.write"
      , "lab.laser.disclose"
      , "lab.laser.manage"
      ]
    , Drucker3D.permissions =
      [ "lab.3D.read", "lab.3D.write", "lab.3D.disclose", "lab.3D.manage" ]
    , Plasma.permissions =
      [ "lab.plasma.read"
      , "lab.plasma.write"
      , "lab.plasma.disclose"
      , "lab.plasma.manage"
      ]
    , PlattenSaege.permissions =
      [ "lab.plattensaege.read"
      , "lab.plattensaege.write"
      , "lab.plattensaege.disclose"
      , "lab.plattensaege.manage"
      ]
    , FormatSaege.permissions =
      [ "lab.formatsaege.read"
      , "lab.formatsaege.write"
      , "lab.formatsaege.disclose"
      , "lab.formatsaege.manage"
      ]
    , DrehFraes.permissions =
      [ "lab.drehfraes.read"
      , "lab.drehfraes.write"
      , "lab.drehfraes.disclose"
      , "lab.drehfraes.manage"
      ]
    , StickMaschine.permissions =
      [ "lab.stickmasch.read"
      , "lab.stickmasch.write"
      , "lab.stickmasch.disclose"
      , "lab.stickmasch.manage"
      ]
    , Staenderbohrmaschine.permissions =
      [ "lab.staenderbohrmasch.read"
      , "lab.staenderbohrmasch.write"
      , "lab.staenderbohrmasch.disclose"
      , "lab.staenderbohrmasch.manage"
      ]
    , Kantenschleifer.permissions =
      [ "lab.kantenschleifer.read"
      , "lab.kantenschleifer.write"
      , "lab.kantenschleifer.disclose"
      , "lab.kantenschleifer.manage"
      ]
    , BandsaegeHolz.permissions =
      [ "lab.bandsaege.read"
      , "lab.bandsaege.write"
      , "lab.bandsaege.disclose"
      , "lab.bandsaege.manage"
      ]
    , Drechselbank.permissions =
      [ "lab.drechseln.read"
      , "lab.drechseln.write"
      , "lab.drechseln.disclose"
      , "lab.drechseln.manage"
      ]
    , Hobelmaschine.permissions =
      [ "lab.hobelmasch.read"
      , "lab.hobelmasch.write"
      , "lab.hobelmasch.disclose"
      , "lab.hobelmasch.manage"
      ]
    , CNCmittel.permissions =
      [ "lab.cncmittel.read"
      , "lab.cncmittel.write"
      , "lab.cncmittel.disclose"
      , "lab.cncmittel.manage"
      ]
    , CNCgross.permissions =
      [ "lab.cncgross.read"
      , "lab.cncgross.write"
      , "lab.cncgross.disclose"
      , "lab.cncgross.manage"
      ]
    , Brennofen.permissions =
      [ "lab.brennofen.read"
      , "lab.brennofen.write"
      , "lab.brennofen.disclose"
      , "lab.brenofen.manage"
      ]
    , crew =
      { parents = [ "profi" ]
      , permissions =
        [ "crew.read", "crew.write", "crew.disclose", "crew.admin", "lab.*" ]
      }
    , admin =
      { parents = [ "crew" ]
      , permissions =
        [ "admin.read"
        , "admin.write"
        , "admin.disclose"
        , "admin.admin"
        , "bffh.users.manage"
        , "bffh.users.admin"
        , "bffh.users.info"
        ]
      }
    }
  , machines =
    { Shelly-Blau =
      { description = "A test machine"
      , disclose = "basis.disclose"
      , category = "test"
      , manage = "basis.read"
      , name = "Shelly Blau"
      , read = "basis.read"
      , write = "basis.write"
      }
    , JorisHilft =
      { description = "Projektsupport"
      , disclose = "basis.disclose"
      , category = "Support"
      , manage = "basis.read"
      , name = "Joris hilft"
      , read = "basis.read"
      , write = "basis.write"
      }
    , TanjaHilft =
      { description = "Projektsupport"
      , disclose = "basis.disclose"
      , category = "Support"
      , manage = "basis.read"
      , name = "Tanja hilft"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Shelly-Rot =
      { description = "A test machine"
      , disclose = "crew.disclose"
      , category = "test"
      , manage = "admin.admin"
      , name = "Shelly Rot"
      , read = "crew.read"
      , write = "crew.write"
      }
    , Willkommen =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "doorrole.manage"
      , name = "AUF schliessen"
      , read = "doorrole.read"
      , write = "doorrole.write"
      }
    , ResetTuer =
      { description = "Setzt Tuersteuerung zurueck"
      , category = "Management"
      , disclose = "doorrole.disclose"
      , manage = "doorrole.manage"
      , name = "Reset Tuer"
      , read = "doorrole.read"
      , write = "doorrole.write"
      }
    , AufWiedersehen =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "doorrole.manage"
      , name = "ZU schliessen"
      , read = "doorrole.read"
      , write = "doorrole.write"
      }
    , LogIn =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Einloggen?"
      , read = "basis.read"
      , write = "basis.write"
      }
    , LogOut =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Ausloggen?"
      , read = "basis.read"
      , write = "basis.write"
      }
    , LichtOben =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Licht Oben"
      , read = "basis.read"
      , write = "basis.write"
      }
    , LichtHinten =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Licht Hinten"
      , read = "basis.read"
      , write = "basis.write"
      }
    , LichtLager =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Licht Lager"
      , read = "basis.read"
      , write = "basis.write"
      }
    , LeinwandDunkel =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Leinwand Dunkel"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Kompressor =
      { category = "Management"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Kompressor"
      , read = "basis.read"
      , write = "basis.write"
      }
    , SkyLaser9060 =
      { category = "Fablab"
      , disclose = "admin.disclose"
      , manage = "lab.laser.manage"
      , name = "SkyLaser9060"
      , read = "lab.laser.read"
      , write = "lab.laser.write"
      }
    , ElektronikBereich =
      { disclose = "admin.disclose"
      , manage = "crew.write"
      , name = "Elektronik Bereich"
      , read = "basis.read"
      , write = "basis.write"
      }
    , StickMaschine =
      { description = "Nutzung der Stickmaschine"
      , category = "Textilwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.stickmasch.manage"
      , name = "Stickmaschine"
      , read = "lab.stickmasch.read"
      , write = "lab.stickmasch.write"
      }
    , TextilSchrank =
      { description = "Schranktuer zur Stickmaschine"
      , category = "Textilwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.stickmasch.manage"
      , name = "Tuer Textilschrank"
      , read = "lab.stickmasch.read"
      , write = "lab.stickmasch.write"
      }
    , Drucker-3D-Kampshoff =
      { category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "3D Kapshoff"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Mk3S =
      { category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "3D Prusa Mk3S"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-RexII =
      { category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bresser REX II"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Bambu-P1P =
      { description = "abweichende Druckkosten!"
      , category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bambu P1P"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Bambu-A1 =
      { description = "abweichende Druckkosten!"
      , category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bambu A1"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Bambu-A1-AMS =
      { description = "abweichende Druckkosten!"
      , category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bambu A1 AMS"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Bambu-A1-mini =
      { description = "abweichende Druckkosten!"
      , category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bambu A1 mini"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , Drucker-3D-Bambu-A1-mini-AMS =
      { description = "abweichende Druckkosten!"
      , category = "3D Druck"
      , disclose = "admin.disclose"
      , manage = "lab.3D.manage"
      , name = "Bambu A1 mini AMS"
      , read = "lab.3D.read"
      , write = "lab.3D.write"
      }
    , SandstrahlGross =
      { category = "Metallwerkstatt"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Sandstrahlkabine Gross"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Plasma =
      { category = "Schweissen"
      , disclose = "admin.disclose"
      , manage = "lab.plasma.manage"
      , name = "Plasma CNC"
      , read = "lab.plasma.read"
      , write = "lab.plasma.write"
      }
    , Schweissen3 =
      { description = "Arbeitsplatz Stirnseite 380V"
      , category = "Schweissen"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Schweissen Platz 3"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Schweissen1 =
      { description = "Arbeitsplatz zum Gas 230V"
      , category = "Schweissen"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Schweissen Platz 1"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Schweissen2 =
      { description = "Arbeitsplatz hinten 230V/380V"
      , category = "Schweissen"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Schweissen Platz 2"
      , read = "basis.read"
      , write = "basis.write"
      }
    , Schweissgas =
      { description = "Gasmagnetverntil Schweissgas"
      , category = "Schweissen"
      , disclose = "admin.disclose"
      , manage = "basis.write"
      , name = "Schweissgas"
      , read = "basis.read"
      , write = "basis.write"
      }
    , DrehFraes =
      { category = "Metallwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.drehfraes.manage"
      , name = "Drehbank und Fraese"
      , read = "lab.drehfraes.read"
      , write = "lab.drehfraes.write"
      }
    , Staenderbohrmaschine =
      { category = "Metallwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.staenderbohrmasch.manage"
      , name = "Staenderbohrmaschine"
      , read = "lab.staenderbohrmasch.read"
      , write = "lab.staenderbohrmasch.write"
      }
    , CNCmittel =
      { category = "Metallwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.cncmittel.manage"
      , name = "Mittler CNC"
      , read = "lab.cncmittel.read"
      , write = "lab.cncmittel.write"
      }
    , PlattenSaege =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.plattensaege.manage"
      , name = "Plattensaege"
      , read = "lab.plattensaege.read"
      , write = "lab.plattensaege.write"
      }
    , FormatSaege =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.formatsaege.manage"
      , name = "Formatkreissaege"
      , read = "lab.formatsaege.read"
      , write = "lab.formatsaege.write"
      }
    , BandsaegeHolz =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.bandsaege.manage"
      , name = "Bandsaege Holz"
      , read = "lab.bandsaege.read"
      , write = "lab.bandsaege.write"
      }
    , Kantenschleifer =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.kantenschleifer.manage"
      , name = "Kantenschleifer"
      , read = "lab.kantenschleifer.read"
      , write = "lab.kantenschleifer.write"
      }
    , CNCgross =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.cncgross.manage"
      , name = "Grosse CNC Holz"
      , read = "lab.cncgross.read"
      , write = "lab.cncgross.write"
      }
    , Drechselbank =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.drechseln.manage"
      , name = "Grosse Drechselbank"
      , read = "lab.drechseln.read"
      , write = "lab.drechseln.write"
      }
    , Hobelmaschine =
      { category = "Holzwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.hobelmasch.manage"
      , name = "Abricht- und Dickenhobel"
      , read = "lab.hobelmasch.read"
      , write = "lab.hobelmasch.write"
      }
    , Brennofen =
      { category = "Kreativwerkstatt"
      , disclose = "admin.disclose"
      , manage = "lab.brennofen.manage"
      , name = "Brennofen"
      , read = "lab.brennofen.read"
      , write = "lab.brennofen.write"
      }
    }
  , actors =
    { shelly1-REDACTEDID01 = { module = "Shelly", params = {=} }
    , shelly1pm-REDACTEDID16 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID02 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID03 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID04 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID05 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID06 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID07 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID08 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID09 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID10 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID11 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID12 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID13 = { module = "Shelly", params = {=} }
    , shelly1-REDACTEDID14 = { module = "Shelly", params = {=} }
    , shelly1minig3-REDACTEDID15 =
      { module = "Process"
      , params = { cmd = "./examples/ActorShellyMini.py", args = "-vvv" }
      }
    , shelly1minig3-REDACTEDID17 =
      { module = "Process"
      , params = { cmd = "./examples/ActorShellyMini.py", args = "-vvv" }
      }
    , shelly1minig3-REDACTEDID18 =
      { module = "Process"
      , params = { cmd = "./examples/ActorShellyMini.py", args = "-vvv" }
      }
    , shelly1minig3-REDACTEDID19 =
      { module = "Process"
      , params = { cmd = "./examples/ActorShellyMini.py", args = "-vvv" }
      }
    , OpenTheDoor =
      { module = "Process"
      , params = { cmd = "./examples/actor.py", args = "-vvv" }
      }
    , LastPersonOut =
      { module = "Process"
      , params = { cmd = "./examples/actor.py", args = "-vvv" }
      }
    , reset =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , SkyLaser9060 =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dKampshoff =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dBambuA1mini =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dBambuA1miniAMS =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dBambuA1AMS =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dBambuA1 =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dMk3S =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dRexII =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , d3dBambuP1P =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , DrehFraes =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , Stickmaschine =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , TextilSchrank =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , SandstrahlGross =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , Schweissen1 =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , Schweissen2 =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , CNCmittel =
      { module = "Process"
      , params = { cmd = "./examples/ActorTasmota.py", args = "-vvv" }
      }
    , LogIn =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogOut =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogLastPersonOut =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogOpenTheDoor =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logreset =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogSkyLaser9060 =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dKampshoff =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dBambuA1mini =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dBambuA1miniAMS =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dBambuA1AMS =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dBambuA1 =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dMk3S =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dRexII =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , Logd3dBambuP1P =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogStickmaschine =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogTextilSchrank =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogJorisHilft =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogTanjaHilft =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogElektronikBereich =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogSandstrahlGross =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogPlasma =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogSchweissen3 =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogSchweissen1 =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogSchweissen2 =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogDrehFraes =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogStaenderbohrmaschine =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogCNCmittel =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogFormatSaege =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogPlattenSaege =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogKantenschleifer =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogBandsaegeHolz =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogCNCgross =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogDrechselbank =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogHobelmaschine =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogKompressor =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    , LogBrennofen =
      { module = "Process"
      , params = { cmd = "./examples/CSVlog.py", args = "-vvv" }
      }
    }
  , actor_connections =
    [ { machine = "Shelly-Blau", actor = "shelly1-REDACTEDID01" }
    , { machine = "Shelly-Rot", actor = "shelly1pm-REDACTEDID16" }
    , { machine = "Willkommen", actor = "OpenTheDoor" }
    , { machine = "Willkommen", actor = "LogOpenTheDoor" }
    , { machine = "ResetTuer", actor = "reset" }
    , { machine = "ResetTuer", actor = "Logreset" }
    , { machine = "AufWiedersehen", actor = "LastPersonOut" }
    , { machine = "AufWiedersehen", actor = "LogLastPersonOut" }
    , { machine = "LogIn", actor = "LogIn" }
    , { machine = "LogOut", actor = "LogOut" }
    , { machine = "LichtLager", actor = "shelly1-REDACTEDID13" }
    , { machine = "LeinwandDunkel", actor = "shelly1minig3-REDACTEDID17" }
    , { machine = "LichtOben", actor = "shelly1minig3-REDACTEDID18" }
    , { machine = "LichtHinten", actor = "shelly1minig3-REDACTEDID19" }
    , { machine = "Kompressor", actor = "LogKompressor" }
    , { machine = "SkyLaser9060", actor = "SkyLaser9060" }
    , { machine = "SkyLaser9060", actor = "LogSkyLaser9060" }
    , { machine = "Drucker-3D-Kampshoff", actor = "d3dKampshoff" }
    , { machine = "Drucker-3D-Kampshoff", actor = "Logd3dKampshoff" }
    , { machine = "Drucker-3D-Bambu-A1-mini", actor = "d3dBambuA1mini" }
    , { machine = "Drucker-3D-Bambu-A1-mini", actor = "Logd3dBambuA1mini" }
    , { machine = "Drucker-3D-Bambu-A1-mini-AMS", actor = "d3dBambuA1miniAMS" }
    , { machine = "Drucker-3D-Bambu-A1-mini-AMS"
      , actor = "Logd3dBambuA1miniAMS"
      }
    , { machine = "Drucker-3D-Bambu-A1-AMS", actor = "d3dBambuA1AMS" }
    , { machine = "Drucker-3D-Bambu-A1-AMS", actor = "Logd3dBambuA1AMS" }
    , { machine = "Drucker-3D-Bambu-A1", actor = "d3dBambuA1" }
    , { machine = "Drucker-3D-Bambu-A1", actor = "Logd3dBambuA1" }
    , { machine = "Drucker-3D-Mk3S", actor = "d3dMk3S" }
    , { machine = "Drucker-3D-Mk3S", actor = "Logd3dMk3S" }
    , { machine = "Drucker-3D-RexII", actor = "d3dRexII" }
    , { machine = "Drucker-3D-RexII", actor = "Logd3dRexII" }
    , { machine = "Drucker-3D-Bambu-P1P", actor = "d3dBambuP1P" }
    , { machine = "Drucker-3D-Bambu-P1P", actor = "Logd3dBambuP1P" }
    , { machine = "StickMaschine", actor = "Stickmaschine" }
    , { machine = "StickMaschine", actor = "LogStickmaschine" }
    , { machine = "TextilSchrank", actor = "TextilSchrank" }
    , { machine = "TextilSchrank", actor = "LogTextilSchrank" }
    , { machine = "JorisHilft", actor = "LogJorisHilft" }
    , { machine = "TanjaHilft", actor = "LogTanjaHilft" }
    , { machine = "SandstrahlGross", actor = "SandstrahlGross" }
    , { machine = "SandstrahlGross", actor = "LogSandstrahlGross" }
    , { machine = "Plasma", actor = "shelly1-REDACTEDID04" }
    , { machine = "Plasma", actor = "LogPlasma" }
    , { machine = "Schweissen3", actor = "shelly1-REDACTEDID03" }
    , { machine = "Schweissen3", actor = "LogSchweissen3" }
    , { machine = "Schweissen1", actor = "Schweissen1" }
    , { machine = "Schweissen1", actor = "LogSchweissen1" }
    , { machine = "Schweissen2", actor = "Schweissen2" }
    , { machine = "Schweissen2", actor = "LogSchweissen2" }
    , { machine = "Schweissgas", actor = "shelly1-REDACTEDID14" }
    , { machine = "Staenderbohrmaschine", actor = "shelly1-REDACTEDID07" }
    , { machine = "Staenderbohrmaschine", actor = "LogStaenderbohrmaschine" }
    , { machine = "CNCmittel", actor = "CNCmittel" }
    , { machine = "CNCmittel", actor = "LogCNCmittel" }
    , { machine = "ElektronikBereich", actor = "shelly1-REDACTEDID02" }
    , { machine = "ElektronikBereich", actor = "LogElektronikBereich" }
    , { machine = "Kantenschleifer", actor = "shelly1-REDACTEDID08" }
    , { machine = "Kantenschleifer", actor = "LogKantenschleifer" }
    , { machine = "Drechselbank", actor = "shelly1-REDACTEDID11" }
    , { machine = "Drechselbank", actor = "LogDrechselbank" }
    , { machine = "Hobelmaschine", actor = "shelly1-REDACTEDID12" }
    , { machine = "Hobelmaschine", actor = "LogHobelmaschine" }
    , { machine = "CNCgross", actor = "shelly1-REDACTEDID09" }
    , { machine = "CNCgross", actor = "LogCNCgross" }
    , { machine = "BandsaegeHolz", actor = "shelly1-REDACTEDID10" }
    , { machine = "BandsaegeHolz", actor = "LogBandsaegeHolz" }
    , { machine = "DrehFraes", actor = "DrehFraes" }
    , { machine = "DrehFraes", actor = "LogDrehFraes" }
    , { machine = "PlattenSaege", actor = "shelly1-REDACTEDID06" }
    , { machine = "PlattenSaege", actor = "LogPlattenSaege" }
    , { machine = "FormatSaege", actor = "shelly1-REDACTEDID05" }
    , { machine = "FormatSaege", actor = "LogFormatSaege" }
    , { machine = "Brennofen", actor = "shelly1minig3-REDACTEDID15" }
    , { machine = "Brennofen", actor = "LogBrennofen" }
    ]
  , initiators = {=}
  , init_connections = [] : List { machine : Text, initiator : Text }
  }
